package mcfall.raytracer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class DebugWindow extends JDialog {
	private JEditorPane contentPane;
	private JScrollPane scrollPane;
	private SearchPanel searchPanel;
	
	
	public DebugWindow (JFrame parent, String renderedFilename, String debugFilename) {
		super (parent, false);
		setLayout (new BorderLayout());
		
		setTitle ("Debug results - " + renderedFilename);
		
		try {
			contentPane = new JEditorPane (new File(debugFilename).toURL());
			contentPane.setEditable(false);
			scrollPane = new JScrollPane (contentPane);
			scrollPane.setPreferredSize(new Dimension(600, 400));
			
			searchPanel = new SearchPanel (contentPane);
			add("Center", scrollPane);
			add("South", searchPanel);
			
			pack ();			
		} catch (MalformedURLException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
}
